/*  Datawarehouse - DB-Funktionen

    Archivieren vorgegebene Spalten jeweils am ersten des Monats um 1 Uhr. Die archivierung der daten wird über das
    Standard-SQL "DailyDBFunctions.Datawarehouse" gestartet.

SELECT tlog.datawarehouse_all_set( CURRENT_DATE::DATE )
FROM information_schema.routines
WHERE
    ( date_part( 'day', CURRENT_DATE ) = 1 )
  AND routine_schema = 'tlog'
  AND routine_name = 'datawarehouse_all_set'
;

*/

-- Artikelstamm
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_art_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_art
            SELECT
                _snapshot_date
                , ak_nr
                , ak_standard_mgc
                , ak_hest
                , ak_rust
                , ak_fertk
                , ak_matk
                , ak_awkost
                , ak_los
                , ak_vkpbas
                , ak_vkpfaktor
                , ak_vkprund
                , ak_vkpbasfix
                , ak_tot
                , ak_res
                , ak_bes
                , ak_verfueg
                , ak_ks
            FROM art
            WHERE NOT ak_nr LIKE 'AW.%'
            ;
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Verkauf
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_auftg_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_auftg (
                snapshot_date
                , p_id
                , p_code
                , p_nummer
                , p_pos
                --
                , p_aknr
                --
                , p_menge_gme
                , p_mengeb_gme
                , p_mengel_gme
                , p_mengef_gme
                --
                , p_ks
                --
                , p_preis_me
                , p_preis_gwaer
                , p_preis_sumsubpos
                , p_waer
                , p_kurs
                , p_steu_code
                , p_steu_proz
                , p_rabatt
                , p_rabatt_able
                --
                , p_preis_netto
                , p_wert_tot_netto
                , p_wert_tot_netto_gwaer
                , p_wert_not_werthg
                , p_IsUmsatz --Alt
                --
                , p_datum_eingang
                , p_datum_erfasst
                , p_datum_soll
                , p_datum_ist
                --
                , p_done
                , p_storniert
                , p_datum_storniert
                --
                , p_adkrz
                , p_adkrzl
                , p_adkrzf

                , p_rahmen_id
                , p_allgv4
              )
            SELECT
                _snapshot_date
                , p_id
                , p_code
                , p_nummer
                , p_pos
                --
                , p_aknr
                --
                , p_menge_gme
                , p_mengeb_gme
                , p_mengel_gme
                , p_mengef_gme
                --
                , p_ks
                --
                , p_preis_me
                , p_preis_gwaer
                , p_preis_sumsubpos
                , p_waer
                , p_kurs
                , p_steu_code
                , p_steu_proz
                , p_rabatt
                , p_rabatt_able
                --
                , p_preis_netto
                , p_wert_tot_netto
                , p_wert_tot_netto_gwaer
                , p_wert_not_werthg
                , NOT p_wert_not_werthg AS p_IsUmsatz --Alt
                --
                , p_datum_eingang
                , p_datum_erfasst
                , p_datum_soll
                , p_datum_ist
                --
                , p_done
                , p_storniert
                , p_datum_storniert
                --
                , p_adk_ad_krz
                , p_ada_krzl
                , p_ada_krzf

                , p_rahmen_id
                , p_allgv4
            FROM TWawi.Auftg_PosAll AS Auftg_Pos

           WHERE -- Aktuell: nur Externe Angebote/Aufträge. Keine Materialliste
                 NOT p_code IN ('I')
             AND (   -- nur Aufträge, welche nicht bereits mit erledigt im Vorzeitraum existierten. Es werden also nur Veränderungen an laufenden Aufträgen geloggt und oder der Auftrag einmalig, wenn dieser geschlossen ist.
                     NOT p_done
                     -- auftrag bereits mit erledigt im vorzeitraum vorhanden
                  OR NOT EXISTS(SELECT true FROM tlog.datawarehouse_auftg da WHERE da.p_id = Auftg_Pos.p_id AND da.p_done AND da.snapshot_date < _snapshot_date)
                  )
           ;
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Lager
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_lag_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        -- TODO AXS vergangene Zeitpunkte zulassen
        INSERT INTO tlog.datawarehouse_lag
            SELECT
                _snapshot_date
                , lg_id
                , lg_aknr
                , lg_ort
                , lg_anztot
                , lg_chnr
                , lg_sperr
                , lgo_verfgbar
                , lgo_werthg
                , lgo_beistell
              FROM lag
              LEFT JOIN lagerorte ON lgo_name = lg_ort;
                   -- lagerorte__get_setup(lg_ort)
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Überfunktion
CREATE OR REPLACE FUNCTION TLog.DataWarehouse_all_set(
        IN _snapshot_date DATE
    )
        RETURNS void
    AS $$
    BEGIN
        PERFORM tlog.datawarehouse_art_set( _snapshot_date );
        PERFORM tlog.datawarehouse_auftg_set( _snapshot_date );
        PERFORM tlog.datawarehouse_lag_set( _snapshot_date );
        RETURN;
    END $$ LANGUAGE plpgsql;
--

-- Rahmen-Info zum Snapshot
CREATE OR REPLACE FUNCTION tlog.datawarehouse_auftg__rahmen_info__by__p_id__snapshot__get(
    IN  _p_rahmen_id    integer,
    IN  _snapshot_date  date,
    OUT rahmen_stk_gme  numeric,  -- Rahmenmenge
    OUT rahmen_stkl_gme numeric,  -- gelieferte Menge
    OUT rahmen_stko_gme numeric   -- offene Menge (noch nicht abgerufene Menge)
  )
  RETURNS record
  AS $$
  DECLARE
    _abrufe_stk_gme  numeric;
  BEGIN

    -- Rahemninfo holen
    SELECT p_menge_gme  --Rahmenmenge
      INTO rahmen_stk_gme
      FROM tlog.datawarehouse_auftg
     WHERE p_id = _p_rahmen_id
       AND snapshot_date = _snapshot_date
       AND (     p_code = 'R'
             OR (p_code = 'E' AND p_pos = 0)
           );

    -- eingegebene ag_id ist kein Rahmen, dann weg
    IF rahmen_stk_gme IS null THEN
      RETURN;
    END IF;

    -- Alle Abrufe zur p_id
    -- Da abgeschlossene Aufträge nur einmalig geloggt werden, müssen für alle Abrufe alle Snapshots betrachtet werden
    -- Relavent ist jedoch immer nur der Zustand aus dem aktuellsten Snapshot in dem der Abruf geführt wird.
    SELECT sum( greatest( p_menge_gme, p_mengel_gme ) )
         , sum( p_mengel_gme )
      INTO _abrufe_stk_gme
         , rahmen_stkl_gme
      FROM ( SELECT DISTINCT ON (p_id)
                    p_menge_gme
                  , p_mengel_gme
               FROM tlog.datawarehouse_auftg
              WHERE p_rahmen_id = _p_rahmen_id
                AND snapshot_date <= _snapshot_date
                AND NOT p_storniert
              ORDER BY p_id, snapshot_date DESC NULLS LAST
           ) AS abrufe;

    -- weniger als 0 gibts nicht
    rahmen_stko_gme :=  greatest( (   coalesce( rahmen_stk_gme, 0)
                                    - coalesce(_abrufe_stk_gme, 0) )
                                  , 0
                            );
    RETURN;

  END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT PARALLEL SAFE;